/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity.barrel.mode;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import novamachina.exnihilosequentia.common.blockentity.barrel.AbstractBarrelEntity;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.BarrelModeRegistry;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.FluidTransformBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.MobSpawnBarrelMode;
import novamachina.exnihilosequentia.common.item.DollItem;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.TankUtil;

public class FluidsBarrelMode
extends AbstractBarrelMode {
    public FluidsBarrelMode(@Nonnull String name) {
        super(name);
    }

    @Override
    public void tick(@Nonnull AbstractBarrelEntity barrelTile) {
        if (barrelTile.getFluidAmount() <= 0) {
            barrelTile.setMode(BarrelModeRegistry.getModeFromName("empty"));
        }
        if (barrelTile.getFluidAmount() >= AbstractBarrelEntity.MAX_FLUID_AMOUNT) {
            if (this.fluidOnTop(barrelTile)) {
                return;
            }
            Level world = barrelTile.m_58904_();
            if (world != null) {
                BlockPos blockPosBelow = barrelTile.m_58899_().m_142082_(0, -1, 0);
                Block blockBelow = world.m_8055_(blockPosBelow).m_60734_();
                this.fluidTransform(barrelTile, (ItemLike)blockBelow);
            }
        }
    }

    private boolean doMobSpawn(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull Player player, @Nonnull InteractionHand handIn) {
        if (barrelTile.getFluidAmount() < AbstractBarrelEntity.MAX_FLUID_AMOUNT) {
            return false;
        }
        Item item = player.m_21120_(handIn).m_41720_();
        if (item instanceof DollItem) {
            DollItem doll = (DollItem)item;
            Fluid barrelFluid = barrelTile.getFluid();
            if (barrelFluid != null && barrelFluid.m_6212_(doll.getSpawnFluid())) {
                barrelTile.setMode("mob");
                ((MobSpawnBarrelMode)barrelTile.getMode()).setDoll(doll);
                player.m_21120_(handIn).m_41774_(1);
                return true;
            }
        }
        return false;
    }

    private boolean fluidTransform(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull ItemLike catalyst) {
        Fluid fluidInTank = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.isValidRecipe(fluidInTank, catalyst)) {
            barrelTile.setMode("transform");
            ((FluidTransformBarrelMode)barrelTile.getMode()).setCatalyst(catalyst);
            return true;
        }
        return false;
    }

    private boolean fluidOnTop(AbstractBarrelEntity barrelTile) {
        if (barrelTile.getFluidAmount() < AbstractBarrelEntity.MAX_FLUID_AMOUNT) {
            return false;
        }
        Level world = barrelTile.m_58904_();
        if (world == null) {
            return false;
        }
        Fluid fluidOnTop = world.m_6425_(barrelTile.m_58899_().m_142082_(0, 1, 0)).m_76152_();
        Fluid fluidInTank = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.isValidRecipe(fluidInTank, fluidOnTop)) {
            barrelTile.getTank().setFluid(FluidStack.EMPTY);
            barrelTile.getInventory().setStackInSlot(0, ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.getResult(fluidInTank, fluidOnTop));
            barrelTile.setMode("block");
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public InteractionResult onBlockActivated(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull IFluidHandler fluidHandler, @Nonnull IItemHandler itemHandler) {
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41619_()) {
            return InteractionResult.SUCCESS;
        }
        if (TankUtil.drainWaterIntoBottle(barrelTile, player, fluidHandler)) {
            return InteractionResult.SUCCESS;
        }
        if (TankUtil.drainWaterFromBottle(barrelTile, player, fluidHandler)) {
            return InteractionResult.SUCCESS;
        }
        boolean result = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)handIn, (IFluidHandler)fluidHandler);
        if (result) {
            Level world;
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            if ((world = barrelTile.m_58904_()) != null) {
                BlockState blockState = barrelTile.m_58900_();
                world.m_7260_(barrelTile.m_58899_(), blockState, blockState, 2);
            }
            barrelTile.m_6596_();
            return InteractionResult.SUCCESS;
        }
        if (this.fluidBlockTransform(barrelTile, player, handIn)) {
            return InteractionResult.SUCCESS;
        }
        Item catalyst = player.m_21120_(handIn).m_41720_();
        if (this.fluidTransform(barrelTile, (ItemLike)catalyst)) {
            player.m_21120_(handIn).m_41774_(1);
        }
        this.doMobSpawn(barrelTile, player, handIn);
        return InteractionResult.SUCCESS;
    }

    private boolean fluidBlockTransform(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull Player player, @Nonnull InteractionHand handIn) {
        Item input;
        if (barrelTile.getFluidAmount() < AbstractBarrelEntity.MAX_FLUID_AMOUNT) {
            return false;
        }
        Fluid fluid = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_BLOCK_REGISTRY.isValidRecipe(fluid, input = player.m_21120_(handIn).m_41720_())) {
            barrelTile.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
            barrelTile.getInventory().setStackInSlot(0, new ItemStack(ExNihiloRegistries.FLUID_BLOCK_REGISTRY.getResult(fluid, input)));
            if (!player.m_7500_()) {
                player.m_21120_(handIn).m_41774_(1);
            }
            barrelTile.setMode("block");
            return true;
        }
        return false;
    }

    @Override
    public boolean canFillWithFluid(@Nonnull AbstractBarrelEntity barrel) {
        return true;
    }

    @Override
    public boolean isEmptyMode() {
        return false;
    }

    @Override
    protected boolean isTriggerItem(@Nonnull ItemStack stack) {
        return FluidUtil.getFluidContained((ItemStack)stack).map(FluidStack::getAmount).orElse(0) >= 1000 || ItemStack.m_41746_((ItemStack)stack, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
    }

    @Override
    public void read(@Nonnull CompoundTag nbt) {
    }

    @Override
    @Nonnull
    public CompoundTag write() {
        return new CompoundTag();
    }

    @Override
    protected void spawnParticle(@Nonnull AbstractBarrelEntity barrelTile) {
    }

    @Override
    @Nonnull
    public List<Component> getWailaInfo(@Nonnull AbstractBarrelEntity barrelTile) {
        ArrayList<Component> info = new ArrayList<Component>();
        String key = barrelTile.getFluid() == null ? Fluids.f_76191_.m_76145_().m_76188_().m_60734_().m_7705_() : barrelTile.getFluid().m_76145_().m_76188_().m_60734_().m_7705_();
        info.add((Component)new TranslatableComponent("waila.barrel.fluidAmount", new Object[]{new TranslatableComponent(key), barrelTile.getFluidAmount()}));
        return info;
    }

    @Override
    @Nonnull
    public ItemStack handleInsert(@Nonnull AbstractBarrelEntity barrelTile, @Nonnull ItemStack stack, boolean simulate) {
        Item input;
        if (barrelTile.getFluidAmount() < AbstractBarrelEntity.MAX_FLUID_AMOUNT) {
            return stack.m_41777_();
        }
        ItemStack returnStack = stack.m_41777_();
        Fluid fluid = barrelTile.getTank().getFluid().getFluid();
        if (ExNihiloRegistries.FLUID_BLOCK_REGISTRY.isValidRecipe(fluid, input = stack.m_41720_())) {
            if (!simulate) {
                barrelTile.getTank().drain(1000, IFluidHandler.FluidAction.EXECUTE);
                barrelTile.getInventory().setStackInSlot(0, new ItemStack(ExNihiloRegistries.FLUID_BLOCK_REGISTRY.getResult(fluid, input)));
                barrelTile.setMode("block");
            }
            returnStack.m_41774_(1);
            return returnStack;
        }
        if (input instanceof DollItem) {
            DollItem doll = (DollItem)input;
            Fluid barrelFluid = barrelTile.getFluid();
            if (barrelFluid != null && barrelFluid.m_6212_(doll.getSpawnFluid())) {
                if (!simulate) {
                    barrelTile.setMode("mob");
                    ((MobSpawnBarrelMode)barrelTile.getMode()).setDoll(doll);
                }
                returnStack.m_41774_(1);
            }
        }
        return returnStack;
    }
}

